using System.Data;

namespace gov.va.med.vbecs.DAL.VAL
{	
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>12/22/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Provides means for getting blood bank users information from VistA system via VistALink.</summary>

	#endregion

	public class BloodBankUsers
	{
		private const string BLOOD_BANK_USER_LOOKUP_RPC_NAME = "VBECS BLOOD BANK USER LOOKUP";

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/6/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4205"> 
		///		<ExpectedInput>VistALink is connected.</ExpectedInput>
		///		<ExpectedOutput>Non-empty DataSet with expected data containing a list of Blood Bank users from VistA.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4206"> 
		///		<ExpectedInput>VistALink is not connected.</ExpectedInput>
		///		<ExpectedOutput>InvalidOperationException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update> 
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		/// Retrieves a list of blood bank users by calling 
		/// corresponding VistA RPC via VistALink.
		///</summary>
		///<returns><see cref="DataSet"/> containing a list of blood bank users with their divisional access information.</returns>
		public static DataSet GetBloodBankUsers()
		{
#if DEBUG
			string _rpcResult = VistALink.GetRpcBroker().ExecuteRpc( VistALink.CreateRpcRequest( BLOOD_BANK_USER_LOOKUP_RPC_NAME ) );
			//string _rpcResult = GetTempDebugXmlImitation();
#else
			string _rpcResult = VistALink.GetRpcBroker().ExecuteRpc( VistALink.CreateRpcRequest( BLOOD_BANK_USER_LOOKUP_RPC_NAME ) );
#endif
			return DataTransformUtility.LoadXmlStringIntoDataSet( _rpcResult );
		}

#if DEBUG
		private static string GetTempDebugXmlImitation()
		{
			return
				@"<BloodBankUsers>
				<Record count=""105"">
					<BloodBankUser>
					<UserName>AHZZXY,JEUDTSXWEHU I</UserName>
					<UserDUZ>37846</UserDUZ>
					<UserInitials>JIA</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ANTROPOV,STAS</UserName>
					<UserDUZ>53300</UserDUZ>
					<UserInitials>sa</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ARTH,ZLUN</UserName>
					<UserDUZ>37870</UserDUZ>
					<UserInitials>mjl</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>BALTIERRA,RICHARD</UserName>
					<UserDUZ>53328</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>BDSH,UXKHUS</UserName>
					<UserDUZ>24138</UserDUZ>
					<UserInitials>KB</UserInitials>
					<Divisions>
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>BHAAHN,QDJSXUDL Z</UserName>
					<UserDUZ>9311</UserDUZ>
					<UserInitials>QZB</UserInitials>
					<Divisions>
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>BRACE,NIKI</UserName>
					<UserDUZ>53299</UserDUZ>
					<UserInitials>NB</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>BURNS,KAREN</UserName>
					<UserDUZ>53303</UserDUZ>
					<UserInitials>kyb</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>BURTH,ZLUB</UserName>
					<UserDUZ>23994</UserDUZ>
					<UserInitials>ZB</UserInitials>
					<Divisions>
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>BYDJBUHEZ,IHYDTH L</UserName>
					<UserDUZ>2668</UserDUZ>
					<UserInitials>ILB</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>CEBELINSKI,GREGORY J</UserName>
					<UserDUZ>53291</UserDUZ>
					<UserInitials>GJC</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>CHOU,JULIUS</UserName>
					<UserDUZ>53313</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>CHYYDYFT,BHYYHSE P</UserName>
					<UserDUZ>15726</UserDUZ>
					<UserInitials>BC</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>CLJBTXY,JEUDTSXWEHU H</UserName>
					<UserDUZ>39489</UserDUZ>
					<UserInitials>JC</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>COLLINS,SHARON</UserName>
					<UserDUZ>53326</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>DOBRANOWSKI,KRZYSZTOF</UserName>
					<UserDUZ>53304</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>EHWEYHU,SHUHTL C</UserName>
					<UserDUZ>11630</UserDUZ>
					<UserInitials>SCE</UserInitials>
					<Divisions>
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>EHYIHUTXY,HIPLUI W</UserName>
					<UserDUZ>15801</UserDUZ>
					<UserInitials>HWE</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ELAA,ZLUB W</UserName>
					<UserDUZ>245</UserDUZ>
					<UserInitials>ZWE</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ELUTJE,ULYILAA Z</UserName>
					<UserDUZ>37842</UserDUZ>
					<UserInitials>UZE</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ELUUDTXY,WLS</UserName>
					<UserDUZ>37841</UserDUZ>
					<UserInitials>WE</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>EVERHART,SID</UserName>
					<UserDUZ>53345</UserDUZ>
					<UserInitials>SE</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>FDAZXUH,LAGUHIL W</UserName>
					<UserDUZ>6928</UserDUZ>
					<UserInitials>LZF</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>FUHHY,ADYIL</UserName>
					<UserDUZ>24731</UserDUZ>
					<UserInitials>AK</UserInitials>
					<Divisions>
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>FXUFHT,FPHY B</UserName>
					<UserDUZ>11697</UserDUZ>
					<UserInitials>FBF</UserInitials>
					<Divisions>
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>GALEHUSN,JXYYDH A</UserName>
					<UserDUZ>24194</UserDUZ>
					<UserInitials>JAG</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>GASPERINI,RONALD</UserName>
					<UserDUZ>53305</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>GRAVES,CATHI</UserName>
					<UserDUZ>53306</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>HEUER,CINDY</UserName>
					<UserDUZ>53290</UserDUZ>
					<UserInitials>CAH</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>IHGGHYKLRFE,IHKXULE T</UserName>
					<UserDUZ>32558</UserDUZ>
					<UserInitials>ITI</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>IHQADY,QDSLADL Z</UserName>
					<UserDUZ>23702</UserDUZ>
					<UserInitials>QZI</UserInitials>
					<Divisions>
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ILPTXY,PDAADLZ H</UserName>
					<UserDUZ>41704</UserDUZ>
					<UserInitials>PHI</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ILZDJX,EDAIL U</UserName>
					<UserDUZ>32800</UserDUZ>
					<UserInitials>EUI</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>JABLONSKI,MARGARET</UserName>
					<UserDUZ>53308</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>JAYASHEELA,PRASHANTHI</UserName>
					<UserDUZ>53354</UserDUZ>
					<UserInitials>PJ</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>JULPGXUI,TSHWEHY P</UserName>
					<UserDUZ>25</UserDUZ>
					<UserInitials>TPJ</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>JXXWHU,JEUDTSDYH S</UserName>
					<UserDUZ>29439</UserDUZ>
					<UserInitials>BJ</UserInitials>
					<Divisions>
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>JXYTSLYJH,BUDTSDYH Z</UserName>
					<UserDUZ>24410</UserDUZ>
					<UserInitials>BZJ</UserInitials>
					<Divisions>
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>KDTEXW,KHSSN</UserName>
					<UserDUZ>24520</UserDUZ>
					<UserInitials>KK</UserInitials>
					<Divisions>
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>KHUFZLY,CLYHS</UserName>
					<UserDUZ>37856</UserDUZ>
					<UserInitials>CK</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>KIRK,ALAN</UserName>
					<UserDUZ>53297</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>KUXPY,FLNAH L</UserName>
					<UserDUZ>1242</UserDUZ>
					<UserInitials>FLG</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>KXYIDH,CXEY S</UserName>
					<UserDUZ>41949</UserDUZ>
					<UserInitials>CK</UserInitials>
					<Divisions>
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>LAKLYN,DTJ</UserName>
					<UserDUZ>32528</UserDUZ>
					<UserInitials>ERROR--NO NAME PASSED</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>LOHSE,GREG</UserName>
					<UserDUZ>53311</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>LUZTSUXYF,CLYHS T</UserName>
					<UserDUZ>23992</UserDUZ>
					<UserInitials>CL</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>LZUHDY,HALDYH L</UserName>
					<UserDUZ>39263</UserDUZ>
					<UserInitials>HLL</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>MALMROSE,CARY</UserName>
					<UserDUZ>3</UserDUZ>
					<UserInitials>CM</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>MEYER,CHUCK</UserName>
					<UserDUZ>53314</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>MEYER,LUKE</UserName>
					<UserDUZ>53315</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>MILLER,VALERIE</UserName>
					<UserDUZ>53317</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>MORTON,RANDY</UserName>
					<UserDUZ>7</UserDUZ>
					<UserInitials>RLM</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>MURCH,CLAUDETTE</UserName>
					<UserDUZ>53293</UserDUZ>
					<UserInitials>CM</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>PATCH,USER</UserName>
					<UserDUZ>1</UserDUZ>
					<UserInitials>PU</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>PDAADLZT,CXTHWEDYH A</UserName>
					<UserDUZ>32529</UserDUZ>
					<UserInitials>CAP</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>PHASXY,HQHANY</UserName>
					<UserDUZ>37855</UserDUZ>
					<UserInitials>HP</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>PHDAKLJEHU,AHL LYY</UserName>
					<UserDUZ>37854</UserDUZ>
					<UserInitials>AP</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>PHHTYHU,IXY</UserName>
					<UserDUZ>24149</UserDUZ>
					<UserInitials>IHP</UserInitials>
					<Divisions>
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>PHLQHU,JLUXANY Z</UserName>
					<UserDUZ>23839</UserDUZ>
					<UserInitials>JZP</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>PLABRW,CXEY E</UserName>
					<UserDUZ>2142</UserDUZ>
					<UserInitials>CEP</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589GB"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>PLSHUT,FLAH C</UserName>
					<UserDUZ>6617</UserDUZ>
					<UserInitials>FCP</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>QLYJH,UXN B</UserName>
					<UserDUZ>43318</UserDUZ>
					<UserInitials>QBU</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>RIDINGS,SCOTT</UserName>
					<UserDUZ>5</UserDUZ>
					<UserInitials>SR</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ROBERTS,JERILYN</UserName>
					<UserDUZ>53295</UserDUZ>
					<UserInitials>JR</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>RUPERT,MATTHEW</UserName>
					<UserDUZ>53318</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>SAUNDERS,TOM</UserName>
					<UserDUZ>4</UserDUZ>
					<UserInitials>TS</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>SDASXY,UXKHUS I</UserName>
					<UserDUZ>41644</UserDUZ>
					<UserInitials>US</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>SOUTHALL,DOUGLAS</UserName>
					<UserDUZ>53320</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>STALLING,FRANK</UserName>
					<UserDUZ>53344</UserDUZ>
					<UserInitials>FS</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>SURHAXQH,JELUAHT</UserName>
					<UserDUZ>24706</UserDUZ>
					<UserInitials>JS</UserInitials>
					<Divisions>
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>SXAHT,UHO A</UserName>
					<UserDUZ>24208</UserDUZ>
					<UserInitials>UHO</UserInitials>
					<Divisions>
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>TJELSSH,UXKHUS F</UserName>
					<UserDUZ>23993</UserDUZ>
					<UserInitials>UFT</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>TJEPLUSM,ZLUN T</UserName>
					<UserDUZ>42003</UserDUZ>
					<UserInitials>ZTT</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>TOMLIN,BRIAN N</UserName>
					<UserDUZ>53296</UserDUZ>
					<UserInitials>BNT</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>TPDSADB,CLZHT C</UserName>
					<UserDUZ>1320</UserDUZ>
					<UserInitials>jj</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>TRWWXUS,DTJ</UserName>
					<UserDUZ>24200</UserDUZ>
					<UserInitials>DTJ</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>TSLSSHAZLY,ZDJELHA L</UserName>
					<UserDUZ>32102</UserDUZ>
					<UserInitials>ZLT</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>TWHYJHU,UXKDY A</UserName>
					<UserDUZ>38472</UserDUZ>
					<UserInitials>UAT</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>UHFL,LYYH</UserName>
					<UserDUZ>24052</UserDUZ>
					<UserInitials>LU</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ULDYHT,AXUHSSL</UserName>
					<UserDUZ>49129</UserDUZ>
					<UserInitials>AU</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ULJBHU,BLN LIHAH</UserName>
					<UserDUZ>34217</UserDUZ>
					<UserInitials>BLU</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>VANSTEDUM,CARRIE</UserName>
					<UserDUZ>53322</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>VANTU,QUYNH</UserName>
					<UserDUZ>53323</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>VBECSUSER,ONE</UserName>
					<UserDUZ>2</UserDUZ>
					<UserInitials>CT</UserInitials>
					<Divisions>
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>VROOLAND,JOHN</UserName>
					<UserDUZ>53324</UserDUZ>
					<UserInitials>
					</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>WLUUN,FHXUFH H</UserName>
					<UserDUZ>1138</UserDUZ>
					<UserInitials>FOW</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>XKUNLY,SHUUN W</UserName>
					<UserDUZ>327</UserDUZ>
					<UserInitials>SWX</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>XTEHL,ZLUN L</UserName>
					<UserDUZ>369</UserDUZ>
					<UserInitials>ZXT</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>YDJXALUTHY,FHULAI A</UserName>
					<UserDUZ>787</UserDUZ>
					<UserInitials>jn</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>YHATXY,HQLY I</UserName>
					<UserDUZ>6410</UserDUZ>
					<UserInitials>MMM</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""677"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZDAAHU,LALY F</UserName>
					<UserDUZ>38066</UserDUZ>
					<UserInitials>LFZ</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZDJELHA,ILQDI H</UserName>
					<UserDUZ>93</UserDUZ>
					<UserInitials>IHZ</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZJJLAA,CXNJH</UserName>
					<UserDUZ>32783</UserDUZ>
					<UserInitials>CZ</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZLRHU,CRIN</UserName>
					<UserDUZ>33083</UserDUZ>
					<UserInitials>CZ</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZLSERU,LYDSL</UserName>
					<UserDUZ>36300</UserDUZ>
					<UserInitials>LZ</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZLTSDY,TLYIUL F</UserName>
					<UserDUZ>33804</UserDUZ>
					<UserInitials>sgm</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZRHAAHU,CLYH K</UserName>
					<UserDUZ>24699</UserDUZ>
					<UserInitials>CKZ</UserInitials>
					<Divisions>
						<Division divisionCode=""589A4"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZUBCHONAK,DENIS</UserName>
					<UserDUZ>53327</UserDUZ>
					<UserInitials>DZ</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A4"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZXSH,YLYJN</UserName>
					<UserDUZ>32784</UserDUZ>
					<UserInitials>YZ</UserInitials>
					<Divisions>
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZXXUH,JNYSEDL I</UserName>
					<UserDUZ>38369</UserDUZ>
					<UserInitials>JIZ</UserInitials>
					<Divisions>
						<Division divisionCode=""589A6"" />
					</Divisions>
					</BloodBankUser>
					<BloodBankUser>
					<UserName>ZXYSLFRH,BLSEN</UserName>
					<UserDUZ>6284</UserDUZ>
					<UserInitials>BZ</UserInitials>
					<Divisions>
						<Division divisionCode=""589"" />
						<Division divisionCode=""589A5"" />
						<Division divisionCode=""589A6"" />
						<Division divisionCode=""589A7"" />
					</Divisions>
					</BloodBankUser>
				</Record>
				</BloodBankUsers>";
		}
#endif
	}
}
